/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.cs.condor.chirp;

import edu.wisc.cs.condor.chirp.ChirpConfig;
import edu.wisc.cs.condor.chirp.ChirpError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ChirpClient {
    private Socket socket = null;
    private OutputStream output = null;
    private InputStream input = null;
    private final String encoding = "US-ASCII";
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;

    public ChirpClient() throws IOException {
        ChirpConfig chirpConfig;
        try {
            String string = System.getProperty(".chirp.config");
            if (string == null) {
                throw new ChirpError("system property chirp.config is not defined!");
            }
            chirpConfig = new ChirpConfig(string);
        }
        catch (Exception exception) {
            throw new ChirpError(exception);
        }
        this.connect(chirpConfig.getHost(), chirpConfig.getPort());
        this.cookie(chirpConfig.getCookie());
    }

    public ChirpClient(String string, int n) throws IOException {
        this.connect(string, n);
    }

    private void connect(String string, int n) throws IOException {
        this.socket = new Socket(string, n);
        this.output = this.socket.getOutputStream();
        this.input = this.socket.getInputStream();
    }

    public void cookie(String string) throws IOException {
        this.simple_command("cookie " + this.ChirpWord(string) + "\n");
    }

    public int open(String string, String string2, int n) throws IOException {
        return this.simple_command("open " + this.ChirpWord(string) + " " + string2 + " " + n + "\n");
    }

    public int open(String string, String string2) throws IOException {
        return this.open(string, string2, 511);
    }

    public void close(int n) throws IOException {
        this.simple_command("close " + n + "\n");
    }

    public int read(int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        try {
            int n5;
            String string = "read " + n + " " + n3 + "\n";
            byte[] byArray2 = string.getBytes("US-ASCII");
            this.output.write(byArray2, 0, byArray2.length);
            this.output.flush();
            n4 = this.getResponse();
            if (n4 > 0 && (n5 = this.fullRead(byArray, n2, n4)) != n4) {
                throw new ChirpError("server disconnected");
            }
        }
        catch (IOException iOException) {
            throw new ChirpError((Exception)iOException);
        }
        return this.returnOrThrow(n4);
    }

    public int write(int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        try {
            String string = "write " + n + " " + n3 + "\n";
            byte[] byArray2 = string.getBytes("US-ASCII");
            this.output.write(byArray2, 0, byArray2.length);
            this.output.write(byArray, n2, n3);
            this.output.flush();
            n4 = this.getResponse();
        }
        catch (IOException iOException) {
            throw new ChirpError((Exception)iOException);
        }
        return this.returnOrThrow(n4);
    }

    public int lseek(int n, int n2, int n3) throws IOException {
        return this.simple_command("seek " + n + " " + n2 + " " + n3 + "\n");
    }

    public void unlink(String string) throws IOException {
        this.simple_command("unlink " + this.ChirpWord(string) + "\n");
    }

    public void rename(String string, String string2) throws IOException {
        this.simple_command("rename " + this.ChirpWord(string) + " " + this.ChirpWord(string2) + "\n");
    }

    public void mkdir(String string, int n) throws IOException {
        this.simple_command("mkdir " + this.ChirpWord(string) + " " + n + "\n");
    }

    public void mkdir(String string) throws IOException {
        this.mkdir(string, 511);
    }

    public void rmdir(String string) throws IOException {
        this.simple_command("rmdir " + this.ChirpWord(string) + "\n");
    }

    public void fsync(int n) throws IOException {
        this.simple_command("fsync " + n + "\n");
    }

    public int version() throws IOException {
        return this.simple_command("version\n");
    }

    public String lookup(String string) throws IOException {
        String string2 = null;
        int n = this.simple_command("lookup " + this.ChirpWord(string) + "\n");
        if (n > 0) {
            byte[] byArray = new byte[n];
            int n2 = this.fullRead(byArray, 0, n);
            if (n2 != n) {
                throw new ChirpError("server disconnected");
            }
            string2 = new String(byArray, 0, n, "US-ASCII");
        }
        this.returnOrThrow(n);
        return string2;
    }

    public void constrain(String string) throws IOException {
        this.simple_command("constrain  " + this.ChirpWord(string) + "\n");
    }

    public String get_job_attr(String string) throws IOException {
        String string2 = null;
        int n = this.simple_command("get_job_attr " + this.ChirpWord(string) + "\n");
        if (n > 0) {
            byte[] byArray = new byte[n];
            int n2 = this.fullRead(byArray, 0, n);
            if (n2 != n) {
                throw new ChirpError("server disconnected");
            }
            string2 = new String(byArray, 0, n, "US-ASCII");
        }
        this.returnOrThrow(n);
        return string2;
    }

    public void set_job_attr(String string, String string2) throws IOException {
        this.simple_command("set_job_attr " + this.ChirpWord(string) + " " + this.ChirpWord(string2) + "\n");
    }

    private int simple_command(String string) throws IOException {
        int n;
        try {
            byte[] byArray = string.getBytes("US-ASCII");
            this.output.write(byArray, 0, byArray.length);
            this.output.flush();
            n = this.getResponse();
        }
        catch (IOException iOException) {
            throw new ChirpError((Exception)iOException);
        }
        return this.returnOrThrow(n);
    }

    public String ChirpWord(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\\': {
                    stringBuffer.append("\\");
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private int returnOrThrow(int n) throws IOException {
        if (n >= 0) {
            return n;
        }
        switch (n) {
            case -1: {
                throw new ChirpError("couldn't authenticate");
            }
            case -2: {
                throw new IOException("permission denied");
            }
            case -3: {
                throw new FileNotFoundException();
            }
            case -4: {
                throw new IOException("file already exists");
            }
            case -5: {
                throw new IOException("argument too big");
            }
            case -6: {
                throw new ChirpError("out of space");
            }
            case -7: {
                throw new OutOfMemoryError();
            }
            case -8: {
                throw new IOException("invalid request");
            }
            case -9: {
                throw new IOException("too many files open");
            }
            case -10: {
                throw new IOException("file is busy");
            }
            case -11: {
                throw new IOException("try again");
            }
            case -12: {
                throw new IOException("invalid file descriptor");
            }
            case -13: {
                throw new IOException("is a directory");
            }
            case -14: {
                throw new IOException("isn't a directory");
            }
            case -15: {
                throw new IOException("directory isn't empty");
            }
            case -16: {
                throw new IOException("cross-device hard link");
            }
            case -17: {
                throw new IOException("offline");
            }
        }
        throw new ChirpError("unknown error");
    }

    private int fullRead(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        while (n2 > 0 && (n3 = this.input.read(byArray, n, n2)) != 0) {
            n += n3;
            n2 -= n3;
            n4 += n3;
        }
        return n4;
    }

    private int getResponse() throws IOException {
        Object object = "";
        byte[] byArray = new byte[]{(byte)this.input.read()};
        while (true) {
            String string;
            if ((string = new String(byArray, 0, 1, "US-ASCII")).charAt(0) == '\n') {
                if (((String)object).length() <= 0) continue;
                return Integer.parseInt((String)object);
            }
            object = (String)object + string;
        }
    }
}

