<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:wix="http://schemas.microsoft.com/wix/2006/wi"
   xmlns:fire="http://schemas.microsoft.com/wix/FirewallExtension">
  <xsl:output indent="yes" method="xml"/>

  <xsl:template match="/wix:Wix">
    <Wix xmlns="http://schemas.microsoft.com/wix/2006/wi">
      <Product xmlns="http://schemas.microsoft.com/wix/2006/wi"
       Id="5f736cfd-b14d-38f1-acb3-512ee7cbaa7b" Name="condor-9.0.8"
       Language="1033" Version="9.0.8"
       Manufacturer="Condor Team - University of Wisconsin Madison" UpgradeCode="EA1CEE00-C44F-4BC4-8035-440AA32C1F33">
        <Package InstallerVersion="405" Compressed="yes"/>
        <Media Id="1" Cabinet="media1.cab" EmbedCab="yes"/>
        <!-- Always force the root drive to be C: -->
        <Directory Id="TARGETDIR" Name="SourceDir">
          <Directory Id="INSTALLDIR" Name="condor">

           <!-- Merge module used to bind VC runtime *do not* copy in the files using include (InstallRequiredSystemLibraries) -->
            <Merge Id="VCCRT" Language="1033" DiskId="1" SourceFile="C:/Program Files (x86)/Common Files/Merge Modules/Microsoft_VC140_CRT_x64.msm"/>


            <!-- Update the registry, ENV, and FW -->
           <Component Id="CondorRegNEnv" Guid="E282D017-976B-4685-A330-5180B27277C0">
             <RegistryKey Root="HKLM" Key="SOFTWARE\Condor" Action="createAndRemoveOnUninstall" >
                 <RegistryValue Type="string" Name="CONDOR_CONFIG" Value="[INSTALLDIR]condor_config" KeyPath="yes" />
                 <RegistryValue Type="string" Name="RELEASE_DIR" Value="[INSTALLDIR]"/>
                 <RegistryValue Type="string" Name="SUBMITJOBS" Value="[SUBMITJOBS]" />
                 <RegistryValue Type="string" Name="NEWPOOL" Value="[NEWPOOL]" />
                 <RegistryValue Type="string" Name="POOLNAME" Value="[POOLNAME]" />
                 <RegistryValue Type="string" Name="POOLHOSTNAME" Value="[POOLHOSTNAME]" />
                 <RegistryValue Type="string" Name="ACCOUNTINGDOMAIN" Value="[ACCOUNTINGDOMAIN]" />
                 <RegistryValue Type="string" Name="CONDOREMAIL" Value="[CONDOREMAIL]" />
                 <RegistryValue Type="string" Name="SMTPSERVER" Value="[SMTPSERVER]" />
                 <RegistryValue Type="string" Name="HOSTALLOWREAD" Value="[HOSTALLOWREAD]" />
                 <RegistryValue Type="string" Name="HOSTALLOWWRITE" Value="[HOSTALLOWWRITE]" />
                 <RegistryValue Type="string" Name="HOSTALLOWADMINISTRATOR" Value="[HOSTALLOWADMINISTRATOR]" />
                 <RegistryValue Type="string" Name="RUNJOBS" Value="[RUNJOBS]" />
                 <RegistryValue Type="string" Name="VACATEJOBS" Value="[VACATEJOBS]" />
                 <RegistryValue Type="string" Name="USEVMUNIVERSE" Value="[USEVMUNIVERSE]" />
                 <RegistryValue Type="string" Name="VMMAXNUMBER" Value="[VMMAXNUMBER]" />
                 <RegistryValue Type="string" Name="VMMEMORY" Value="[VMMEMORY]" />
                 <RegistryValue Type="string" Name="VMNETWORKING" Value="[VMNETWORKING]" />
                 <RegistryValue Type="string" Name="PERLLOCATION" Value="[PERLLOCATION]" />
             </RegistryKey>
             <RegistryKey Root="HKLM" Key="SYSTEM\CurrentControlSet\Services\condor"  Action="createAndRemoveOnUninstall">
               <RegistryValue Type="integer" Name="DelayedAutostart" Value="1" />
               <RegistryValue Type="multiString" Name="DependOnService" Value="Dhcp" />
             </RegistryKey>
             <Environment Id="CondorBin" Action="set" Name="PATH" Part="last" Permanent="no" System="yes" Value="[INSTALLDIR]bin\"/>
             <Environment Id="CondorLibPython" Action="set" Name="PYTHONPATH" Part="last" Permanent="no" System="yes" Value="[INSTALLDIR]lib\python;[INSTALLDIR]bin"/>
           </Component>
            <Component Id="CondorKBDDReg" Guid="3C40071C-6DB9-43AD-8058-920623026740">
              <RegistryKey Root="HKLM" Key="SOFTWARE\Microsoft\Windows\CurrentVersion\Run">
                <RegistryValue Type="string" Name="condor_kbdd" Value="&quot;[INSTALLDIR]bin\condor_kbdd.exe&quot;" />
              </RegistryKey>
              <Condition>RUNJOBS = "I" Or RUNJOBS = "C"</Condition>
            </Component>
            <Component Id="CondorConfigBase" Guid=""> <!-- empty guid prevents removal on uninstall/upgrade -->
              <File Id="condor_config" Name="condor_config" Source="$(var.Source)\etc\condor_config.base" Checksum="no" >
                <Permission User="Administrators" GenericAll="yes" />
                <Permission User="[LogonUser]" GenericAll="yes"/>
                <Permission User="Users" Read="yes" ReadPermission="yes"/>
              </File>
              <Condition>Not UPGRADEFOUND Or HOSTBASEDFOUND</Condition>
            </Component>
            <Component Id="LocalConfigFile" Guid=""> <!-- empty guid prevents removal on uninstall/upgrade -->
              <File Id="condor_config.local" Name="condor_config.local" Source="$(var.Source)\etc\condor_config.local.blank" Checksum="no" >
                <Permission User="Administrators" GenericAll="yes" />
                <Permission User="[LogonUser]" GenericAll="yes"/>
                <Permission User="Users" Read="yes" ReadPermission="yes"/>
              </File>
              <Condition>Not UPGRADEFOUND</Condition>
            </Component>
            <Component Id="CondorConfigIni" Guid="5AD8ADAA-A724-4D98-A64E-58C30F7AF4B5">
              <CreateFolder/> <!-- suppress warning about directory not being created -->
              <IniFile Id="configIniPath" Directory="INSTALLDIR" Name="condor_config" Section="HTCONDOR" Action="addLine" Key="RELEASE_DIR" Value="$$Fpb([INSTALLDIR])" />
              <Condition>Not UPGRADEFOUND Or HOSTBASEDFOUND</Condition>
              <!-- <RemoveFile Id="local_config" On="uninstall" Name="condor_config.local" /> -->
            </Component>
            <Directory Id="LogDir" Name="log">
              <Component Id="CreatingLogDir" Guid="F6731DF5-5E28-405F-82EC-5F269FD434E5" Permanent="no" NeverOverwrite="yes">
                <CreateFolder />
                <RemoveFile Id="LogFiles" On="uninstall" Name="*" />
              </Component>
            </Directory>
            <Directory Id="ExecuteDir" Name="execute">
              <Component Id="CreatingExecuteDir" Guid="389E40FD-5B03-4740-B42A-A9F81AEB853D" Permanent="no" NeverOverwrite="yes">
                <CreateFolder />
                <RemoveFile Id="SandboxFiles" On="uninstall" Name="*" />
              </Component>
            </Directory>
            <Directory Id="SpoolDir" Name="spool">
              <Component Id="CreatingSpoolDir" Guid="A1F2F929-7417-4C67-851C-1645D587540A" Permanent="no" NeverOverwrite="yes">
                <CreateFolder />
                <!-- <RemoveFile Id="SpoolFiles" On="uninstall" Name="*" /> -->
              </Component>
            </Directory>
            <Directory Id="TokenKeyDir" Name="tokens.sk">
              <Component Id="CreatingTokenKeyDir" Guid="C4EF0FB3-7741-4A31-A95C-8F1D407D56AE" Permanent="no" NeverOverwrite="yes">
                <CreateFolder>
                   <Permission User="SYSTEM" GenericAll="yes" />
                   <!-- <Permission User="Administrators" ChangePermission="yes" ReadPermission="yes" Traverse="yes" Synchronize="yes" CreateFile="yes" Delete="yes" DeleteChild="yes" /> -->
                   <Permission User="Administrators" GenericAll="yes" />
                </CreateFolder>
                <RemoveFile Id="LocalSigningKey" On="uninstall" Name="LOCAL" />
              </Component>
            </Directory>
            <Directory Id="TokenDir" Name="tokens.d">
              <Component Id="CreatingTokenDir" Guid="43DFF135-7439-4B18-9E83-B48276D53F7D" Permanent="no" NeverOverwrite="yes">
                <CreateFolder>
                   <Permission User="Administrators" GenericAll="yes" />
                </CreateFolder>
                <RemoveFile Id="AdminTokenFile" On="uninstall" Name="admin" />
              </Component>
            </Directory>
          </Directory>
        </Directory>

        <Condition Message="This application is only supported on Windows XP(SP2) or higher">
          <![CDATA[(VersionNT >= 501)]]>
        </Condition>

        <Property Id="UPGRADEFOUND" Secure="yes" />
        <Property Id="NEWPRODUCTFOUND" Secure="yes" />
        <Upgrade Id="EA1CEE00-C44F-4BC4-8035-440AA32C1F33">
          <!--Upgrading older version of Condor-->
          <UpgradeVersion
            Language="1033"
            Minimum="7.5.5"
            IncludeMinimum="yes"
            Maximum="9.0.8"
            IncludeMaximum="no"
            Property="UPGRADEFOUND"
            OnlyDetect="no"
            RemoveFeatures="ALL"
            />
          <!--Newer version of HTCondor already installed-->
          <UpgradeVersion
            Language="1033"
            Minimum="9.0.8"
            IncludeMinimum="no"
            OnlyDetect="yes"
            Property="NEWPRODUCTFOUND"
            />
          <UpgradeVersion
            Language="1033"
            Maximum="8.9.13"
            IncludeMaximum="yes"
            OnlyDetect="yes"
            Property="HOSTBASEDFOUND"
            />
          <UpgradeVersion
            Language="1033"
            Maximum="7.5.5"
            IncludeMaximum="no"
            OnlyDetect="yes"
            Property="TOOOLDFOUND"
            />
          <UpgradeVersion
            Language="1033"
            Maximum="7.5.5"
            Minimum="7.5.5"
            IncludeMaximum="yes"
            IncludeMinimum="yes"
            Property="SEVENFIVEFIVEFOUND"
            />
        </Upgrade>

        <CustomAction Id="PreventDowngrade" Error="Newer version of HTCondor already installed." />

        <CustomAction Id="PreventUpgrade"
                      Error="HTCondor cannot upgrade from the installed version due to issues with migrating the configuration.  Please backup the configuration and uninstall HTCondor first before attempting to install this version of HTCondor." />

        <Property Id="WIXUI_INSTALLDIR" Value="INSTALLDIR" />

        <!--Find the location of the Java installation-->
        <Property Id="JVMVERSION">
          <RegistrySearch Id="JavaVersionSearch" Root="HKLM" Type="raw" Key="SOFTWARE\JavaSoft\Java Runtime Environment" Name="CurrentVersion" />
        </Property>
        <Property Id="JVMDIR">
          <RegistrySearch Id="JavaDirSearch" Root="HKLM" Type="raw" Key="SOFTWARE\JavaSoft\Java Runtime Environment\[JVMVERSION]" Name="JavaHome" />
        </Property>
        <!-- Verify that registry == reality -->
        <Property Id="JVMFOUND">
            <DirectorySearch Id="JavaDirValidate" Path="[JVMDIR]\bin">
                <FileSearch Name="java.exe"/>
            </DirectorySearch>
        </Property>

        <SetProperty Id="JVMLOCATION" Value="[JVMDIR]\bin\java.exe" After="AppSearch">JVMFOUND</SetProperty>

        <!--Search for previous install answers.-->
        <Property Id="OLD_INSTALLDIR">
          <RegistrySearch Id="INSTALLDIR_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="RELEASE_DIR" />
        </Property>
        <Property Id="OLD_SUBMITJOBS">
          <RegistrySearch Id="SUBMITJOBS_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="SUBMITJOBS" />
        </Property>
        <Property Id="OLD_NEWPOOL">
          <RegistrySearch Id="NEWPOOL_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="NEWPOOL" />
        </Property>
        <Property Id="OLD_POOLNAME">
          <RegistrySearch Id="POOLNAME_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="POOLNAME" />
        </Property>
        <Property Id="OLD_POOLHOSTNAME">
          <RegistrySearch Id="POOLHOSTNAME_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="POOLHOSTNAME" />
        </Property>
        <Property Id="OLD_ACCOUNTINGDOMAIN">
          <RegistrySearch Id="ACCOUNTINGDOMAIN_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="ACCOUNTINGDOMAIN" />
        </Property>
        <Property Id="OLD_CONDOREMAIL">
          <RegistrySearch Id="CONDOREMAIL_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="CONDOREMAIL" />
        </Property>
        <Property Id="OLD_SMTPSERVER">
          <RegistrySearch Id="SMTPSERVER_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="SMTPSERVER" />
        </Property>
        <Property Id="OLD_HOSTALLOWREAD">
          <RegistrySearch Id="HOSTALLOWREAD_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="HOSTALLOWREAD" />
        </Property>
        <Property Id="OLD_HOSTALLOWWRITE">
          <RegistrySearch Id="HOSTALLOWWRITE_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="HOSTALLOWWRITE" />
        </Property>
        <Property Id="OLD_HOSTALLOWADMINISTRATOR">
          <RegistrySearch Id="HOSTALLOWADMINISTRATOR_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="HOSTALLOWADMINISTRATOR" />
        </Property>
        <Property Id="OLD_RUNJOBS">
          <RegistrySearch Id="RUNJOBS_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="RUNJOBS" />
        </Property>
        <Property Id="OLD_VACATEJOBS">
          <RegistrySearch Id="VACATEJOBS_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="VACATEJOBS" />
        </Property>
        <Property Id="OLD_USEVMUNIVERSE">
          <RegistrySearch Id="USEVMUNIVERSE_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="USEVMUNIVERSE" />
        </Property>
        <Property Id="OLD_VMMAXNUMBER">
          <RegistrySearch Id="VMMAXNUMBER_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="VMMAXNUMBER" />
        </Property>
        <Property Id="OLD_VMMEMORY">
          <RegistrySearch Id="VMMEMORY_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="VMMEMORY" />
        </Property>
        <Property Id="OLD_VMNETWORKING">
          <RegistrySearch Id="VMNETWORKING_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="VMNETWORKING" />
        </Property>
        <Property Id="OLD_PERLLOCATION">
          <RegistrySearch Id="PERLLOCATION_search" Root="HKLM" Type="raw" Key="SOFTWARE\Condor" Name="PERLLOCATION" />
        </Property>

        <Property Id="POOLHOSTNAME" Value="$$(IP_ADDRESS)" />
        <!--Permissions properties-->
        <Property Id="HOSTALLOWREAD" Value="*" />
        <Property Id="HOSTALLOWWRITE" Value="*" />
        <CustomAction Id="AdminUserProp" Property="HOSTALLOWADMINISTRATOR" Value="Administrator@*, [LogonUser]@*" />
        <!--VM Universe properties-->
        <Property Id="VMVERSION" Value="server1.0" />
        <Property Id="VMMEMORY" Value="256" />
        <Property Id="VMMAXNUMBER" Value="$$(NUM_CPUS)" />
        <Property Id="VMNETWORKING" Value="N"/>
        <Property Id="PERLLOCATION" Value="PERL.EXE" />

        <SetDirectory Id="TARGETDIR" Value="[INSTALLDIR]" Sequence="execute" />

        <Property Id="LOCALCONFIG" Value="$$(LOCAL_DIR)\condor_config.local" />

        <SetProperty Id="INSTALLDIR" Value="[OLD_INSTALLDIR]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="SUBMITJOBS" Value="[OLD_SUBMITJOBS]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="NEWPOOL" Value="[OLD_NEWPOOL]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="POOLNAME" Value="[OLD_POOLNAME]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="POOLHOSTNAME" Value="[OLD_POOLHOSTNAME]" After="AppSearch">UPGRADEFOUND AND OLD_POOLHOSTNAME</SetProperty>
        <SetProperty Id="ACCOUNTINGDOMAIN" Value="[OLD_ACCOUNTINGDOMAIN]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="CONDOREMAIL" Value="[OLD_CONDOREMAIL]" After="AppSearch">UPGRADEFOUND AND OLD_CONDOREMAIL</SetProperty>
        <SetProperty Id="SMTPSERVER" Value="[OLD_SMTPSERVER]" After="AppSearch">UPGRADEFOUND AND OLD_SMTPSERVER</SetProperty>
        <SetProperty Id="HOSTALLOWREAD" Value="[OLD_HOSTALLOWREAD]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="HOSTALLOWWRITE" Value="[OLD_HOSTALLOWWRITE]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="HOSTALLOWADMINISTRATOR" Value="[OLD_HOSTALLOWADMINISTRATOR]" After="AppSearch">UPGRADEFOUND AND Not HOSTBASEDFOUND</SetProperty>
        <SetProperty Id="RUNJOBS" Value="[OLD_RUNJOBS]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="VACATEJOBS" Value="[OLD_VACATEJOBS]" After="AppSearch">UPGRADEFOUND And (RUNJOBS = "I" Or RUNJOBS = "C")</SetProperty>
        <SetProperty Id="USEVMUNIVERSE" Value="[OLD_USEVMUNIVERSE]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="VMMAXNUMBER" Value="[OLD_VMMAXNUMBER]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="VMMEMORY" Value="[OLD_VMMEMORY]" After="AppSearch">UPGRADEFOUND</SetProperty>
        <SetProperty Id="PERLLOCATION" Value="[OLD_PERLLOCATION]" After="AppSearch">UPGRADEFOUND</SetProperty>

        <!-- Begin custom actions and install sequence -->
        <CustomAction Id="SetInstallProbe"
            Property="InstallProbe" Value="[INSTALLDIR]bin\win_install_probe.exe"
            Execute="immediate"
        />
        <CustomAction Id="ProbeInstall"
            Impersonate="no" Execute="deferred" Return="check"
            Property="InstallProbe"
            ExeCommand="-log [INSTALLDIR]probe.log -dir [INSTALLDIR] -sid [UserSID]"
         />
        <CustomAction Id="SetInstallHelper"
            Property="InstallHelper" Value="[INSTALLDIR]bin\win_install_helper.exe"
            Execute="immediate"
        />
        <CustomAction Id="MakeAdminToken"
            Impersonate="no" Execute="deferred" Return="check"
            Property="InstallHelper"
            ExeCommand="-config [INSTALLDIR]condor_config -log [INSTALLDIR]admintoken.log -sid [UserSID] -key LOCAL -token [INSTALLDIR]tokens.d\admin"
         />

         <CustomAction Id="EditCondorConfig" Script="vbscript">
          <![CDATA[
            Function CreateConfig()
              Set fso = CreateObject("Scripting.FileSystemObject")
              path = Session.Property("INSTALLDIR")
              configscript = fso.BuildPath(path, "etc\WiX\config.vbs")
              If fso.FileExists(configscript) Then
                 Set scriptFile = fso.OpenTextFile(configscript,1)
                 sText = scriptFile.ReadAll
                 scriptFile.close
                 ExecuteGlobal sText
              Else
                 ccpath = fso.BuildPath(path,"condor_config")
                 set file = fso.OpenTextFile(ccpath, 8)
                 file.WriteLine("")
                 file.WriteLine("# make sure the install user can use admin commands")
                 file.WriteLine("INSTALL_USER = " & Session.Property("LogonUser") & "@*")
                 file.WriteLine("ALLOW_ADMINISTRATOR = $$(ALLOW_ADMINISTRATOR) $$(INSTALL_USER)")
                 file.Close
              End If
            End Function
            
            CreateConfig
           ]]>
        </CustomAction>

        <InstallExecuteSequence>
          <Custom Action="PreventDowngrade" After="FindRelatedProducts">NEWPRODUCTFOUND</Custom>
          <Custom Action="PreventUpgrade" After="FindRelatedProducts">TOOOLDFOUND</Custom>
          <RemoveExistingProducts After="InstallValidate">UPGRADEFOUND</RemoveExistingProducts>
          <Custom Action="AdminUserProp" After="AppSearch" >Not UPGRADEFOUND</Custom>
          <Custom Action="SetInstallHelper" After="InstallFiles">Not Installed</Custom>
          <Custom Action="SetInstallProbe" After="InstallFiles">Not Installed</Custom>
          <Custom Action="MakeAdminToken" After="InstallServices">Not Installed</Custom>
          <Custom Action="EditCondorConfig" After="InstallFinalize">Not Installed</Custom>
          <!-- <Custom Action="ProbeInstall" After="SetInstallProbe">Not Installed</Custom> -->
          <!-- <ScheduleReboot After="InstallFinalize" /> -->
        </InstallExecuteSequence>

        <InstallUISequence>
          <Custom Action="PreventDowngrade" After="FindRelatedProducts">NEWPRODUCTFOUND</Custom>
          <Custom Action="PreventUpgrade" After="FindRelatedProducts">TOOOLDFOUND</Custom>
        </InstallUISequence>
        <!-- End custom actions and install sequence -->

        <!-- Feature Block e.g. ComponentRef's -->
        <Feature Id="CondorWindows" Title="HTCondor Installation" Level="1" Display="expand">
          <Feature Id="Installation" Title="HTCondor Installation Files" Level="1"  ConfigurableDirectory="INSTALLDIR">
            <xsl:apply-templates select="wix:Fragment" mode="CompRef"/>
            <!-- Import any merge references -->
            <MergeRef Id="VCCRT"/>

            <ComponentRef Id="CondorConfigBase" />
            <ComponentRef Id="LocalConfigFile" />
            <ComponentRef Id="CondorConfigIni" />
            <ComponentRef Id="CondorRegNEnv" />
            <ComponentRef Id="CondorKBDDReg" />
            <ComponentRef Id="CreatingSpoolDir" />
            <ComponentRef Id="CreatingTokenKeyDir" />
            <ComponentRef Id="CreatingTokenDir" />
            <ComponentRef Id="CreatingExecuteDir"/>
            <ComponentRef Id="CreatingLogDir" />
          </Feature>
          <!-- Typical/Complete/Custom, below is complete. 
          <Feature Id="Debugging Symbols" Title="HTCondor Debug Symbol Files" Description="Files used to debug HTCondor" Level='1000'>
            <xsl:apply-templates select="wix:Fragment" mode="CompRef">
              <xsl:with-param name="ftype">pdb</xsl:with-param>
            </xsl:apply-templates>
          </Feature> -->
        </Feature>

        <!-- UI Flow + our custom dialogs -->
        <UI Id="MyWixUI_FeatureTree">
            <UIRef Id="WixUI_InstallDir" />
            <DialogRef Id="CondorPoolCfgDlg" />
            <DialogRef Id="CondorExecCfgDlg" />
            <DialogRef Id="CondorDomainCfgDlg" />
            <DialogRef Id="CondorEmailCfgDlg" />
            <DialogRef Id="CondorJavaCfgDlg" />
            <DialogRef Id="CondorPermCfgDlg" />
            <DialogRef Id="CondorVMCfgDlg" />
            <Publish Dialog="LicenseAgreementDlg" Control="Next" Event="NewDialog" Value="CondorPoolCfgDlg" Order="2">LicenseAccepted = "1" And Not UPGRADEFOUND</Publish>
            <Publish Dialog="InstallDirDlg" Control="Back" Event="NewDialog" Value="CondorVMCfgDlg">1</Publish>
            <Publish Dialog="InstallDirDlg" Control="Next" Event="NewDialog" Value="VerifyReadyDlg" Order="2">1</Publish>
            <Publish Dialog="VerifyReadyDlg" Control="Back" Event="NewDialog" Value="InstallDirDlg">Not UPGRADEFOUND</Publish>
            <Publish Dialog="LicenseAgreementDlg" Event="NewDialog" Value="VerifyReadyDlg" Control="Next">LicenseAccepted = "1" And UPGRADEFOUND And Not SEVENFIVEFIVEFOUND</Publish>
            <Publish Dialog="LicenseAgreementDlg" Event="NewDialog" Value="CondorUpHostDlg" Control="Next">LicenseAccepted = "1" And UPGRADEFOUND And SEVENFIVEFIVEFOUND</Publish>
            <Publish Dialog="VerifyReadyDlg" Control="Back" Event="NewDialog" Value="LicenseAgreementDlg">UPGRADEFOUND And Not SEVENFIVEFIVEFOUND</Publish>
            <Publish Dialog="VerifyReadyDlg" Control="Back" Event="NewDialog" Value="CondorVMCfgDlg">UPGRADEFOUND And SEVENFIVEFIVEFOUND</Publish>
        </UI>

        <!--<UIRef Id="WixUI_FeatureTree" />-->
        <UIRef Id="WixUI_ErrorProgressText" />

        <!-- Update  -->
        <WixVariable Id="WixUIBannerBmp" Overridable="yes" Value="Bitmaps/bannrbmp.bmp"/>
        <WixVariable Id="WixUIDialogBmp" Overridable="yes" Value="Bitmaps/dlgbmp.bmp"/>

      </Product>

      <!--Output the fragment info which heat generates-->
      <xsl:apply-templates select="wix:Fragment" mode="CopyOf"/>

    </Wix>
  </xsl:template>

  <!-- ************************* Begin Templates ************************* -->
  <!-- Begin CompRef Templates -->
  <xsl:template match="wix:Component" mode="CompRef">
    <xsl:element name="ComponentRef" xmlns="http://schemas.microsoft.com/wix/2006/wi" >
      <xsl:attribute name="Id">
        <xsl:value-of select="@Id" />
      </xsl:attribute>
    </xsl:element>
  </xsl:template>

  <xsl:template match="wix:Directory" mode="CompRef" >
    <xsl:apply-templates select="wix:Component" mode="CompRef"/>
    <xsl:apply-templates select="wix:Directory" mode="CompRef"/>
  </xsl:template>

  <xsl:template match="wix:DirectoryRef" mode="CompRef">
    <xsl:apply-templates select="wix:Component" mode="CompRef"/>
    <xsl:apply-templates select="wix:Directory" mode="CompRef"/>
  </xsl:template>

  <xsl:template match="wix:Fragment" mode="CompRef">
    <xsl:param name="ftype"/>
    <xsl:apply-templates select="wix:DirectoryRef" mode="CompRef"/>
  </xsl:template>

  <!-- Begin CopyOf Templates -->
  <xsl:template match="wix:File" mode="CopyOf">    
    <xsl:choose>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_master.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX1" Name="condor_master.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
          <ServiceInstall Id="CondorService" Description="condor" DisplayName="condor" ErrorControl="normal"  Name="condor" Start="auto" Type="ownProcess" xmlns="http://schemas.microsoft.com/wix/2006/wi" />
          <ServiceControl Id="StartCondorService" Name="condor" Start="install" Wait="no" xmlns="http://schemas.microsoft.com/wix/2006/wi" />
          <ServiceControl Id="StopCondorService" Name="condor" Stop="both" Wait="yes" Remove="uninstall" xmlns="http://schemas.microsoft.com/wix/2006/wi" />
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_schedd.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX2" Name="condor_schedd.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_collector.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX3" Name="condor_collector.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_negotiator.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX4" Name="condor_negotiator.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_startd.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX5" Name="condor_startd.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_kbdd.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX6" Name="condor_kbdd.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_credd.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX7" Name="condor_credd.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_hdfs.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX8" Name="condor_hdfs.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_starter.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX9" Name="condor_starter.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_shadow.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX10" Name="condor_shadow.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_gridmanager.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX11" Name="condor_gridmanager.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_dagman.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX12" Name="condor_dagman.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_c-gahp.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX13" Name="condor_c-gahp.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_c-gahp_worker_thread.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX14" Name="condor_c-gahp_worker_thread.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
       <xsl:when test="@Source = '$(var.Source)\bin\condor_vm-gahp.exe'">
          <xsl:copy>
            <xsl:copy-of select="@*"/>
            <FirewallException Id="FWX15" Name="condor_vm-gahp.exe" Scope="any" xmlns="http://schemas.microsoft.com/wix/FirewallExtension" IgnoreFailure="yes"/>
          </xsl:copy>
       </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:copy-of select="@*"/>
        </xsl:copy> 
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="wix:Component" mode="CopyOf">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="wix:File" mode="CopyOf"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="wix:Directory" mode="CopyOf" >
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="wix:Component" mode="CopyOf"/>
      <xsl:apply-templates select="wix:Directory" mode="CopyOf"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="wix:DirectoryRef" mode="CopyOf">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="wix:Component" mode="CopyOf"/>
      <xsl:apply-templates select="wix:Directory" mode="CopyOf"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="wix:Fragment" mode="CopyOf">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="wix:DirectoryRef" mode="CopyOf"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
